function DoCurve( factoryname, docorners )
{
	var ui = moi.ui;
	var curvefactory = moi.command.createFactory( factoryname );

	moi.command.setCommandSpecificUndo( true );

	var pointpicker = ui.createPointPicker();
	var numpoints = 0;
	var closed = false;

	while ( true )
	{
		curvefactory.createInput( 'point' );
		var pointindex = curvefactory.numInputs - 1;
		
		pointpicker.clearBindings();
		pointpicker.bindResultPt( curvefactory.getInput(pointindex) );

		var boolindex;
		if ( docorners )
		{
			curvefactory.createInput( 'bool' );
			boolindex = curvefactory.numInputs - 1;
			curvefactory.setInput( boolindex, false );
		}
		
		var startpt = null;
		var previouspt = null;
			
		if ( numpoints > 0 )
		{
			startpt = curvefactory.getInput(0).getValue();
			
			var previndex = (docorners ? pointindex - 2 : pointindex - 1);
			previouspt = curvefactory.getInput(previndex).getValue();
			
			if ( numpoints == 1 )
				pointpicker.bindBasePt( curvefactory.getInput(previndex) );
		}

		if ( docorners )
			ui.commandUI.makecorner.value = false;

		ui.beginUIUpdate();

		if ( numpoints == 0 )
		{
			ui.hideUI( 'NextPrompt' );
			ui.showUI( 'StartPrompt' );
			
			if ( docorners )
				ui.hideUI( 'makecornercontainer' );
		}
		else
		{
			ui.hideUI( 'StartPrompt' );
			ui.showUI( 'NextPrompt' );
			
			if ( docorners )
				ui.showUI( 'makecornercontainer' );
		}

		ui.endUIUpdate();

		pointpicker.clearSnapPoints();
		if ( numpoints >= 3 )
			pointpicker.addSnapPoint( startpt, moi.ui.getText('Closed snap') );
			
		pointpicker.resetOnMouseLeave = (numpoints > 1);

		++numpoints;

		var exit = false;
		var undo = false;
		
		while ( 1 )
		{
			if ( !pointpicker.waitForEvent() )
			{
				exit = true;
				break;
			}
			
			if ( pointpicker.event == 'undo' )
			{
				if ( numpoints > 1 )
				{
					numpoints -= 2;
					curvefactory.removeLastInput();
					curvefactory.removeLastInput();
					
					if ( docorners )
					{
						curvefactory.removeLastInput();
						curvefactory.removeLastInput();
					}
					
					pointpicker.clearCurrentSnaps();
					
					ui.removeLastPickedPoint();
					curvefactory.update();
					
					undo = true;
					
					break;
				}
				
				continue;
			}

			if ( docorners )
			{			
				var iscorner = false;
						
				if ( pointpicker.controlDown )
					iscorner = true;
				else
					iscorner = ui.commandUI.makecorner.value;

				curvefactory.setInput( boolindex, iscorner );
				
				if ( pointpicker.controlDown )
					curvefactory.update();
			}

			if ( pointpicker.event == 'done' )
			{
				exit = true;
				break;
			}
			
			if ( pointpicker.event == 'finished' )
				break;
		}
		
		if ( exit )
			break;
			
		if ( undo )
			continue;
			
		if ( previouspt != null && moi.vectorMath.pointsWithinTolerance( previouspt, pointpicker.pt ) )
		{
			--numpoints;
			curvefactory.removeLastInput();
			
			if ( docorners )
				curvefactory.removeLastInput();
				
			ui.removeLastPickedPoint();
		}

		if ( numpoints >= 4 && moi.vectorMath.pointsWithinTolerance( startpt, pointpicker.pt ) )
		{
			closed = true;
			break;
		}
	}

	if ( !closed && numpoints > 0 )
	{
		--numpoints;
		curvefactory.removeLastInput();
		
		if ( docorners )
			curvefactory.removeLastInput();
			
		curvefactory.update();
	}

	if ( numpoints < 2 )
	{
		curvefactory.cancel();
		moi.command.cancel();
	}
	else if ( pointpicker.event == 'cancel' )
	{
		if ( pointpicker.cancelReason == 'newcommandstarting' )
			curvefactory.commit();
		else
			curvefactory.cancel();
	}
	else
	{
		curvefactory.commit();
	}
}
